//*****************************************************************************
//
// ektm4c129_qssi_bootloader.h - The header file to define QSPI Flash Functions.
//
// Copyright (c) 2013-2014 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
//
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
//
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
//
// This is part of revision 2.1.0.12573 of the EK-TM4C1294XL Firmware Package.
//
//*****************************************************************************

#ifndef EKTM4C129_QSSI_BOOTLOADER_H_
#define EKTM4C129_QSSI_BOOTLOADER_H_

extern void QSPIInitFunction(void);
extern void QSPIFlashEnd(void);
extern void QSPIFlashErase(uint32_t ulBlockAddr);
extern void QSPIFlashProgram(uint32_t ulDstAddr,
                             uint8_t *pucSrcData,
                             uint32_t ulLength);
extern void QSPIFlashClearError(void);
extern uint32_t QSPIFlashError(void);
extern uint32_t QSPIFlashSize(void);
extern uint32_t QSPIFlashAddressCheck(uint32_t ulAddr,
									  uint32_t ulSize);

#endif /* EKTM4C129_QSSI_BOOTLOADER_H_ */
