/*
 * Decompiled with CFR 0.152.
 */
package fsigraphs.dualline.trellis;

import fsi.FSICore;
import fsi.FSIExecutionPoint;
import fsi.RX1vsCLKCollection;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BubbleChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.imageio.ImageIO;

public class GraphFSIDelayTrellis_FXMLController
implements Initializable {
    @FXML
    private Tab SetRX0CLKvsRX1_TAB;
    @FXML
    private ScrollPane AllGraphsSetRX0CLKvsRX1_SP;
    @FXML
    private VBox AllGraphsSetRX0CLKvsRX1_VB;
    @FXML
    private TableView<ExecutionPointItem> ExecutionPointTable_TV;
    @FXML
    private TableColumn ExecutionPointCLK_TC;
    @FXML
    private TableColumn ExecutionPointRX0_TC;
    @FXML
    private TableColumn ExecutionPointRX1_TC;
    @FXML
    private Label ExecutionPoints_L;
    GraphMode Mode = GraphMode.SetRX0CLKvsRX1;
    private Stage ParentStage;
    @FXML
    private VBox AllGraphs_VB;
    @FXML
    private ScrollPane AllGraphs_SP;
    @FXML
    private ScrollPane AllGraphsRX0vsCLK_SP;
    @FXML
    private VBox AllGraphsRX0vsCLK_VB;
    @FXML
    private ScrollPane AllGraphsRX1vsCLK_SP;
    @FXML
    private VBox AllGraphsRX1vsCLK_VB;
    @FXML
    private Tab RX0vsRX1_TAB;
    @FXML
    private Tab RX0vsCLK_TAB;
    @FXML
    private Tab RX1vsCLK_TAB;
    @FXML
    private TabPane TabPzne_TP;

    public void initialize(URL url, ResourceBundle rb) {
    }

    public void SetStage(Stage stage) {
        this.ParentStage = stage;
    }

    public void SetMode(GraphMode mode) {
        this.Mode = mode;
    }

    public void SetData(boolean[][][] data, FSIExecutionPoint execPoint) {
        if (data != null) {
            this.Mode = execPoint == null ? GraphMode.Rx1vsCLK : GraphMode.SetRX0CLKvsRX1;
            if (this.Mode == GraphMode.RX0vsRX1) {
                this.CreateRX0vsRX1Charts(data);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsCLK_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.RX1vsCLK_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.SetRX0CLKvsRX1_TAB);
            } else if (this.Mode == GraphMode.RX0vsCLK) {
                this.CreateRX0vsCLKCharts(data);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsRX1_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.RX1vsCLK_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.SetRX0CLKvsRX1_TAB);
            } else if (this.Mode == GraphMode.Rx1vsCLK) {
                this.CreateRX1vsCLKCharts(data);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsRX1_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsCLK_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.SetRX0CLKvsRX1_TAB);
            } else if (execPoint != null) {
                this.CreateSetRX0CLKvsRX1Chart(data, execPoint);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsCLK_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.RX0vsRX1_TAB);
                this.TabPzne_TP.getTabs().remove((Object)this.RX1vsCLK_TAB);
            }
        }
    }

    private void CreateSetRX0CLKvsRX1Chart(boolean[][][] data, FSIExecutionPoint execPoint) {
        NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
        NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
        xAxis.setLabel("CLK Delay");
        yAxis.setLabel("RX1 Delay");
        BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
        blc.setTitle("RX1 Delay vs. Set RX0 and CLK ");
        XYChart.Series successSeries = new XYChart.Series();
        successSeries.setName("Success");
        XYChart.Series failSeries = new XYChart.Series();
        failSeries.setName("Failure");
        RX1vsCLKCollection rx1VsCLK = FSICore.GenerateSingleLineRX1vsCLKArray(data, execPoint);
        FSIExecutionPoint dualLineExePoint = FSICore.CalculateDualLineExecutionPoint(rx1VsCLK);
        for (int clk = 0; clk < 32; ++clk) {
            for (int rx1 = 0; rx1 < 32; ++rx1) {
                if (rx1VsCLK.GetStatus(clk, rx1)) {
                    successSeries.getData().add((Object)new XYChart.Data((Object)clk, (Object)rx1, (Object)0.4));
                    continue;
                }
                failSeries.getData().add((Object)new XYChart.Data((Object)clk, (Object)rx1, (Object)0.1));
            }
        }
        blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
        blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
        blc.prefHeightProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.maxHeightProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.minHeightProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.prefWidthProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.maxWidthProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        blc.minWidthProperty().bind((ObservableValue)this.AllGraphsSetRX0CLKvsRX1_SP.heightProperty());
        this.AddExecutionPointToChart(blc, dualLineExePoint);
        this.SetExecutionPointTable(dualLineExePoint);
        this.ExecutionPoints_L.setText("Selected Execution Point: (CLK = " + dualLineExePoint.CLKDelay + ", RX0 = " + dualLineExePoint.RX0Delay + ", RX1 = " + dualLineExePoint.RX1Delay + ")");
        this.AllGraphsSetRX0CLKvsRX1_VB.getChildren().add((Object)blc);
    }

    public void AddExecutionPointToChart(BubbleChart chart, FSIExecutionPoint point) {
        if (point != null) {
            XYChart.Series execPointSeries = new XYChart.Series();
            execPointSeries.setName("Execution Point");
            execPointSeries.getData().add((Object)new XYChart.Data((Object)point.CLKDelay, (Object)point.RX1Delay, (Object)0.5));
            int y = point.RX1Delay;
            for (int x = point.CLKDelay; x < 32; ++x) {
                if (y < 32) {
                    execPointSeries.getData().add((Object)new XYChart.Data((Object)x, (Object)y, (Object)0.2));
                    int n = x - point.CLKDelay;
                }
                ++y;
            }
            chart.getData().add((Object)execPointSeries);
        }
    }

    private void SetExecutionPointTable(FSIExecutionPoint point) {
        ObservableList tableData = FXCollections.observableArrayList();
        this.ExecutionPointCLK_TC.setCellValueFactory((Callback)new PropertyValueFactory("clk"));
        this.ExecutionPointRX0_TC.setCellValueFactory((Callback)new PropertyValueFactory("rx0"));
        this.ExecutionPointRX1_TC.setCellValueFactory((Callback)new PropertyValueFactory("rx1"));
        this.ExecutionPointTable_TV.setItems(tableData);
        if (point != null) {
            int y = point.RX1Delay;
            for (int x = point.CLKDelay; x < 32; ++x) {
                if (y < 32) {
                    int offset = x - point.CLKDelay;
                    tableData.add((Object)new ExecutionPointItem(point.RX0Delay + offset, y, x));
                }
                ++y;
            }
        }
    }

    public void CreateRX0vsRX1Charts(boolean[][][] data) {
        for (int clk = 0; clk < 32; ++clk) {
            NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
            NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
            xAxis.setLabel("RX0 Delay");
            yAxis.setLabel("RX1 Delay");
            BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
            blc.setTitle("CLK Delay " + String.valueOf(clk));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int rx0 = 0; rx0 < 32; ++rx0) {
                for (int rx1 = 0; rx1 < 32; ++rx1) {
                    if (data[clk][rx0][rx1]) {
                        successSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)rx1, (Object)0.4));
                        continue;
                    }
                    failSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)rx1, (Object)0.1));
                }
            }
            blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
            blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
            blc.prefHeightProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            blc.maxHeightProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            blc.minHeightProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            blc.prefWidthProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            blc.maxWidthProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            blc.minWidthProperty().bind((ObservableValue)this.AllGraphs_SP.heightProperty());
            this.AllGraphs_VB.getChildren().add((Object)blc);
        }
    }

    public void CreateRX0vsCLKCharts(boolean[][][] data) {
        for (int rx1 = 0; rx1 < 32; ++rx1) {
            NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
            NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
            xAxis.setLabel("RX0 Delay");
            yAxis.setLabel("CLK Delay");
            BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
            blc.setTitle("RX1 Delay " + String.valueOf(rx1));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int clk = 0; clk < 32; ++clk) {
                for (int rx0 = 0; rx0 < 32; ++rx0) {
                    if (data[clk][rx0][rx1]) {
                        successSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.4));
                        continue;
                    }
                    failSeries.getData().add((Object)new XYChart.Data((Object)rx0, (Object)clk, (Object)0.1));
                }
            }
            blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
            blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
            blc.prefHeightProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            blc.maxHeightProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            blc.minHeightProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            blc.prefWidthProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            blc.maxWidthProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            blc.minWidthProperty().bind((ObservableValue)this.AllGraphsRX0vsCLK_SP.heightProperty());
            this.AllGraphsRX0vsCLK_VB.getChildren().add((Object)blc);
        }
    }

    public void CreateRX1vsCLKCharts(boolean[][][] data) {
        for (int rx0 = 0; rx0 < 32; ++rx0) {
            NumberAxis xAxis = new NumberAxis(-1.0, 32.0, 2.0);
            NumberAxis yAxis = new NumberAxis(-1.0, 32.0, 2.0);
            xAxis.setLabel("RX1 Delay");
            yAxis.setLabel("CLK Delay");
            BubbleChart blc = new BubbleChart((Axis)xAxis, (Axis)yAxis);
            blc.setTitle("RX0 Delay " + String.valueOf(rx0));
            XYChart.Series successSeries = new XYChart.Series();
            successSeries.setName("Success");
            XYChart.Series failSeries = new XYChart.Series();
            failSeries.setName("Failure");
            for (int clk = 0; clk < 32; ++clk) {
                for (int rx1 = 0; rx1 < 32; ++rx1) {
                    if (data[clk][rx0][rx1]) {
                        successSeries.getData().add((Object)new XYChart.Data((Object)rx1, (Object)clk, (Object)0.4));
                        continue;
                    }
                    failSeries.getData().add((Object)new XYChart.Data((Object)rx1, (Object)clk, (Object)0.1));
                }
            }
            blc.getData().addAll((Object[])new XYChart.Series[]{successSeries});
            blc.getData().addAll((Object[])new XYChart.Series[]{failSeries});
            blc.prefHeightProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            blc.maxHeightProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            blc.minHeightProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            blc.prefWidthProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            blc.maxWidthProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            blc.minWidthProperty().bind((ObservableValue)this.AllGraphsRX1vsCLK_SP.heightProperty());
            this.AllGraphsRX1vsCLK_VB.getChildren().add((Object)blc);
        }
    }

    private void screenshot(ActionEvent event) {
        WritableImage image = ((Node)this.AllGraphs_VB.getChildren().get(0)).snapshot(new SnapshotParameters(), null);
        File file = new File("chart.png");
        try {
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null) {
            job.showPrintDialog((Window)this.ParentStage);
            job.printPage((Node)this.AllGraphs_VB);
            job.endJob();
        }
    }

    public class ExecutionPointItem {
        private final SimpleIntegerProperty clk;
        private final SimpleIntegerProperty rx0;
        private final SimpleIntegerProperty rx1;

        private ExecutionPointItem(int rx0, int rx1, int clk) {
            this.clk = new SimpleIntegerProperty(clk);
            this.rx0 = new SimpleIntegerProperty(rx0);
            this.rx1 = new SimpleIntegerProperty(rx1);
        }

        public int getClk() {
            return this.clk.get();
        }

        public void setClk(int clk) {
            this.clk.set(clk);
        }

        public int getRx0() {
            return this.rx0.get();
        }

        public void setRx0(int rx0) {
            this.rx0.set(rx0);
        }

        public int getRx1() {
            return this.rx1.get();
        }

        public void setRx1(int rx1) {
            this.rx1.set(rx1);
        }
    }

    public static enum GraphMode {
        RX0vsCLK,
        Rx1vsCLK,
        RX0vsRX1,
        SetRX0CLKvsRX1;

    }
}

