/* --COPYRIGHT--,BSD
 * Copyright (c) 2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//   HAL functions to control Sounder/Buzzer Hardware
//
// Texas Instruments, Inc.
// Jan 2020
// Luis R
// *****************************************************************************
#include <msp430.h>
#include <stdint.h>
#include <stdlib.h>
#include <DualRaySmokeAFE_HAL.h>
#include "DualRaySmokeAFE_HAL_Config_Private.h"

/**** Functions **************************************************************/
void DualRaySmokeAFE_HAL_Sounder_Init(
                                tDualRaySmokeAFE_HAL_Sounder_Config *Config)
{
    // P5.0 / TB2.1 used for buzzer
    // Initialize OFF by default
    P5OUT &= ~BIT0;
    P5DIR |= BIT0;

    // Initialize TB2 to control Buzzer PWM
    // PWM Freq = Clock source / (period *2)
    // i.e. 32768 / (33*2) = ~496Hz
    TB2CCR0 = (LSBUS_FREQ_HZ / (Config->u16Freq)) / 2;
    // PWM Duty cycle set to 50% of period
    TB2CCR1 = TB2CCR0/2;
    TB2CCTL1 = OUTMOD_6;                // TBCCR1 toggle/set
    TB2CTL = TBSSEL__ACLK | TBCLR| MC__STOP;   // ACLK, stop by default

}

void DualRaySmokeAFE_HAL_Sounder_SetOn(void)
{
    TB2CTL = TBSSEL__ACLK | TBCLR| MC__STOP;    // Clear Timer
    TB2CTL |= MC_3;                             // Start timer in up/down
    P5SEL0 |= BIT0;                             // Enable Timer functionality
}

void DualRaySmokeAFE_HAL_Sounder_SetOff(void)
{
    TB2CTL = TBSSEL__ACLK | TBCLR| MC__STOP;    // Stop Timer
    // Disable Timer functionality, restore to GPIO output low
    P5SEL0 &= ~BIT0;

}
