/* --COPYRIGHT--,BSD
 * Copyright (c) 2019, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
//*****************************************************************************
//         DUALRAYSMOKEAFE_App_GUIComm.c
//
// Implementation of GUI communication for Dual Ray Smoke Application
// Texas Instruments, Inc.
// Ver 1.0. July 2019
// Lixin.C
// ******************************************************************************
#include <stdlib.h>
#include <string.h>
#include <DualRaySmokeAFELib.h>
#include <DualRaySmokeAFE_HAL.h>
#include <DualRaySmokeAFE_Config_Common.h>
#include "DualRaySmokeAFE_App.h"
#include "DualRaySmokeAFE_App_Config.h"

#if defined(__TI_COMPILER_VERSION__)
#pragma PERSISTENT(sDualRaySmokeAFELib_Config)
#pragma PERSISTENT(sDualRaySmokeAFE_AppConfig)
#pragma PERSISTENT(sDualRaySmokeAFE_HAL_AFE_Config)
#pragma PERSISTENT(sDualRaySmokeAFE_HAL_Sounder_Config)
#pragma PERSISTENT(sDualRaySmokeAFE_HALConfig)
#endif

__persistent tDualRaySmokeAFE_AppConfig sDualRaySmokeAFE_AppConfig =
{
     .u16MeasIntervalms =
                         DUALRAYSMOKEAFE_APP_DEFAULT_ULPTIMER_INTERVAL_MSEC,
     .u16MeasIntervalms_tempor =
                         DUALRAYSMOKEAFE_APP_DEFAULT_ULPTIMER_INTERVAL_MSEC,
     .u16TempSensorInterval = DUALRAYSMOKEAFE_APP_DEFAULT_TEMPERATURESENSOR_INTERVAL,
     .u16RTCCalibInterval = DUALRAYSMOKEAFE_APP_DEFAULT_ULPTIMER_CALIBRATION_INTERVAL,
     .u16LPPerTimerIntervalms = DUALRAYSMOKEAFE_APP_DEFAULT_LPPERTIMER_INTERVAL_MSEC,
     .u16LPPerTimerCyclesBeforeAlarmOff = ((DUALRAYSMOKEAFE_APP_ALARM_ONTOOFF_SILENT_SEC * 1000) /
                                DUALRAYSMOKEAFE_APP_DEFAULT_LPPERTIMER_INTERVAL_MSEC),
     .u16PPerTimerCyclesAlarmSilent = ((DUALRAYSMOKEAFE_APP_ALARM_SILENT_SEC * 1000) /
                             DUALRAYSMOKEAFE_APP_DEFAULT_LPPERTIMER_INTERVAL_MSEC),
     .APPSTATUS.AlarmOn                = DUALRAYSMOKEAFE_APP_DEFAULT_ALARMON,
     .APPSTATUS.AlarmDetectionEnabled  = DUALRAYSMOKEAFE_APP_DEFAULT_ALARMDETECTIONENABLED,
     .APPSTATUS.HornEnabled            = DUALRAYSMOKEAFE_APP_DEFAULT_HORNENABLED,
     .APPSTATUS.TemperatureMeasEnabled = DUALRAYSMOKEAFE_APP_DEFAULT_TEMPERATUREMEASENABLED,
     .APPSTATUS.RTCCalibEnabled        = DUALRAYSMOKEAFE_APP_DEFAULT_RTCCALIBENABLED,
     .APPCTL.all                       = 0,
};

__persistent tDualRaySmokeAFELib_Config sDualRaySmokeAFELib_Config =
{
     .bAlarmDetectionEnabled = true,
     .i16RefDelta_Threshold[DUALRAYSMOKEAFE_LED_RED] =
                                     DUALRAYSMOKEAFELIB_DEFAULT_IR_THRESHOLD,
     .i16RefDelta_Threshold[DUALRAYSMOKEAFE_LED_BLUE] =
                                     DUALRAYSMOKEAFELIB_DEFAULT_BLUE_THRESHOLD,
};

__persistent tDualRaySmokeAFE_HAL_AFE_Config sDualRaySmokeAFE_HAL_AFE_Config =
{
    .u16LED_CurrentmA[DUALRAYSMOKEAFE_LED_RED] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_IR_CURRENT_MA,
    .u16LED_CurrentmA[DUALRAYSMOKEAFE_LED_BLUE] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_BLUE_CURRENT_MA,
    .u16PGA_Gain[DUALRAYSMOKEAFE_LED_RED] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_IR_PGAGAIN,
    .u16PGA_Gain[DUALRAYSMOKEAFE_LED_BLUE] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_BLUE_PGAGAIN,
    .u16TIABiasmV[DUALRAYSMOKEAFE_LED_RED] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_IR_TIABIASMV,
    .u16TIABiasmV[DUALRAYSMOKEAFE_LED_BLUE] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_BLUE_TIABIASMV,
    .u16PGABiasmV[DUALRAYSMOKEAFE_LED_RED] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_IR_PGABIASMV,
    .u16PGABiasmV[DUALRAYSMOKEAFE_LED_BLUE] =
                                      DUALRAYSMOKEAFELIB_DEFAULT_BLUE_PGABIASMV,
};

__persistent tDualRaySmokeAFE_HAL_Sounder_Config sDualRaySmokeAFE_HAL_Sounder_Config =
{
    .u16Freq = DUALRAYSMOKEAFELIB_DEFAULT_SOUNDERFREQ_HZ,
};

__persistent tDualRaySmokeAFE_HAL_Config sDualRaySmokeAFE_HALConfig =
{
     .AFEConfig = &sDualRaySmokeAFE_HAL_AFE_Config,
     .sounderConfig = &sDualRaySmokeAFE_HAL_Sounder_Config,
};


void DualRaySmokeAFE_App_Config_SetMeasIntervalmsec(uint16_t interval)
{
    // Update measurement intervals
    sDualRaySmokeAFE_AppConfig.u16MeasIntervalms = interval;
    sDualRaySmokeAFE_AppConfig.u16MeasIntervalms_tempor = interval;

    // Update RTC
    DualRaySmokeAFE_HAL_Timing_ULPTimer_setIntervalms(
                           sDualRaySmokeAFE_AppConfig.u16MeasIntervalms);

}


void DualRaySmokeAFE_App_Config_SetTempMeasIntervalmsec(uint16_t interval)
{
    sDualRaySmokeAFE_AppConfig.u16MeasIntervalms_tempor = interval;
    DualRaySmokeAFE_HAL_Timing_ULPTimer_setIntervalms(
                           sDualRaySmokeAFE_AppConfig.u16MeasIntervalms_tempor);
}

void DualRaySmokeAFE_App_Config_RestoreDefaultIntervalmsec(void)
{
    sDualRaySmokeAFE_AppConfig.u16MeasIntervalms_tempor =
                            sDualRaySmokeAFE_AppConfig.u16MeasIntervalms;
    DualRaySmokeAFE_HAL_Timing_ULPTimer_setIntervalms(
                           sDualRaySmokeAFE_AppConfig.u16MeasIntervalms);
}
