************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
 .OPTIONS POST                $ Enables HSPLOT interface
 .OPTIONS ACCT OPTS           $ Prints stats & option values used
 .OPTIONS SPICE=1             $ Forces Berkeley compatibility
 .OPTIONS GMIN=1E-12          $ Lowest allowable conductance values
 .OPTIONS GMINDC=1E-12
 .OPTIONS ITL1=400            $ Maximum DC iteration limit
 .OPTIONS ITL4=40             $ Maximum transient iterations/timestep
 .OPTIONS ITL5=0              $ No limit to total transient iterations



***********************************************************************
***********************************************************************
	.OPTIONS search='./'

* ENCRYPTED DEVICE NETLIST and PROCESS Models. 
*INSTRUCTION- Please remove the comment character (*) from the encrypted device net-list 
* and from any one of the corresponding encrypted nominal, strong and weak  file when testing
* the encrypted net-lits and process file


X_DEVICE_SELECTOR  0 LV132AINC   $ Encrypted device net-list
X_PROCESS_SELECTOR 0  EPIC1SNINC    $ Encrypted nominal process model 
*X_PROCESS_SELECTOR 0  EPIC1SSINC    $ Encrypted strong process model
*X_PROCESS_SELECTOR 0  EPIC1SWINC   $ Encrypted weak process model


*Please include any one of the package. You need to change the corresponding package sub-*circuit name for connection.

*.INCLUDE  SOIC14.PKG
.INCLUDE  SSOP14.PKG
*.INCLUDE  TVSOP14.PKG
*.INCLUDE  SOP14.PKG
*.INCLUDE  TSSOP14.PKG

***********************************************************************
* Refer to the data sheet for node description.
*


***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
xlv132a

+x_1a
+x_1b 
+x_1y
+cgnd
+cvcc


+lv132a__bit

***********************************************************************
******Supply Voltages
***********************************************************************

vcgnd		cgnd	0  dc  0
Vcvcc		cvcc    0  dc 5

***********************************************************************
******Subcircuit for package connection
***********************************************************************
.SUBCKT lv132a  

+p_1a		$PIN 01
+p_1b		$PIN 02
+p_1y	        $PIN 03
+p_cgnd		$PIN 07
+p_cvcc		$PIN 14


X_PIN01      	p_1a      	1a  	D14_01
X_PIN02      	p_1b      	1b  	D14_02
X_PIN03		p_1y		1y	D14_03
X_PIN07		p_cgnd		cgnd	D14_07
X_PIN14		p_cvcc		cvcc	D14_14
 
 
X_lv132a__bit  1a 1b 1y cgnd cvcc  lv132a__bit
.ENDs lv132a

***********************************************************************
***********************************************************************
.temp 50
.param biashv=5v
.param biaslv=0.0
.param supplyv=5v
.param capload=50p
.param resload =500
.param loadv=6

V_load load 0 DC loadv
***********************************************************************
.TRAN         1NS 100NS
*
**** TRANSIENT ANALYSES <-------
** Propagation test (LH/HL)

V1a	   x_1a	   cgnd	PULSE (0  5 5NS  1NS  1NS  20NS  50ns)
V1b        x_1b    cgnd PULSE (0  5 5NS  1NS  1NS  40NS  100ns) 
R_LOAD     x_1y    cgnd     	resload
C_LOAD     x_1y    cgnd     	capload
.END
