*****************************************************************************
* (C) Copyright 2011 Texas Instruments Incorporated. All rights reserved.
*****************************************************************************
** This model is designed as an aid for customers of Texas Instruments.
** TI and its licensors and suppliers makeno warranties, either expressed
** or implied, with respect to thismodel, including the warranties of
** merchantability or fitness fora particular purpose. The model is
** provided solely on an "as is" basis. The entirerisk as to its quality
** and performance is with the customer.
*****************************************************************************
*
* Released by: Analog eLab Design Center, Texas Instruments Inc.
* Part:        TS3DS10224
*              HIGH-SPEED 2:4 DIFFERENTIAL MULTIPLEXER / DEMULTIPLEXER
* Date:        2011-06-23
* Model Type:  HSPICE
* Simulator:   HSPICE D-2010.03-SP2 32 BIT in UNIX
* Datasheet:   Preliminary - Subject to Change. Last Updated on 12/21/2010
*
*****************************************************************************
* Model version 1.0:
*****************************************************************************
*.subckt SAVANNAH sao sbo sbi _net9 _net8 _net11 _net10 _net5 _net7 gnd vdd _net4 _net3 _net2 _net6 enb _net1 _net0 ena sai
******** circuit definition
*.ends
****************************************************************************
*
** The simulations takes almost 2 hrs. to complete
*
****************************************************************************

.PARAM vcmb=1.65
.PARAM vcma=1.65
.PARAM amp_b=350e-3
.PARAM amp_a=350e-3
.PARAM cpad=1e-15
.PARAM vdd=3.3


.PROBE TRAN
+    V(inb_n)
+    V(inb_p)
+    V(ina_n)
+    V(ina_p)
+    V(inbt_n)
+    V(inbt_p)
+    V(inat_n)
+    V(inat_p)
+    V(Vinb)
+    V(Vina)
+    V(sao)
+    V(sbo)
+    V(sbi)
+    V(enb)
+    V(sai)
+    V(ena)
+    V(outb0_n)
+    V(outb0_p)
+    V(outb1_n)
+    V(outb1_p)
+    V(outa0_n)
+    V(outa0_p)
+    V(outa1_n)
+    V(outa1_p)

.TRAN 5n 128e-6 START=0.0

.TEMP 27

.OPTIONS ACCT ACCURATE NOPAGE OPTS POST SCALE=1e-6
.OPTIONS METHOD=GEAR
	
* Encrypted versions
.INCLUDE "TS3DS10224_process_linux.sp"
.INCLUDE "TS3DS10224_ckt_linux.sp"

ea0 inat_p netA   VCVS Vina gnd  1
ea1 netA   inat_n VCVS gnd  Vina 1
ea3 inbt_p netB   VCVS Vinb gnd  1
ea4 netB   inbt_n VCVS gnd  Vinb 1
x0 sao sbo sbi outb0_n outb0_p outb1_n outb1_p outa0_n outa1_n gnd vdd outa0_p inb_n inb_p outa1_p enb ina_n ina_p ena sai SAVANNAH

vpwr vdd 0 DC=vdd PWL 0 0 2e-9 vdd TD=0
vref gnd 0 DC=0

va0 Vina gnd DC=0 SIN 0 amp_a 1e6 0
vb0 Vinb gnd DC=0 AC 0 0 PULSE '-amp_b' amp_b 0 1e-9 1e-9 499e-9 1e-6
va1 netA gnd DC=vcma
vb1 netB gnd DC=vcmb

r15  inat_n ina_n 50
r16  inbt_p inb_p 50
r14  inat_p ina_p 50
r17  inbt_n inb_n 50

* Testing only one state
*ven1 ena  0 DC=vdd
*ven2 enb  0 DC=vdd
*vsb1 sbi  0 DC=0
*vsa0 sao  0 DC=0
*vsa1 sai  0 DC=0
*vsb0 sbo  0 DC=0

* Testing all states
ven1 ena 0 DC=0 AC 0 0 PULSE vdd 0 0 1e-9 1e-9 63.999e-6 128e-6
ven2 enb 0 DC=0 AC 0 0 PULSE vdd 0 0 1e-9 1e-9 31.999e-6  64e-6
vsb0 sbo 0 DC=0 AC 0 0 PULSE 0 vdd 0 1e-9 1e-9  1.999e-6   4e-6
vsb1 sbi 0 DC=0 AC 0 0 PULSE 0 vdd 0 1e-9 1e-9  3.999e-6   8e-6
vsa0 sao 0 DC=0 AC 0 0 PULSE 0 vdd 0 1e-9 1e-9  7.999e-6  16e-6
vsa1 sai 0 DC=0 AC 0 0 PULSE 0 vdd 0 1e-9 1e-9 15.999e-6  32e-6

r1 outb0_n gnd 50
c1 outb0_n gnd 2e-12
r2 outb0_p gnd 50
c2 outb0_p gnd 2e-12
r3 outb1_n gnd 50
c3 outb1_n gnd 2e-12
r4 outb1_p gnd 50
c4 outb1_p gnd 2e-12

r5 outa0_p gnd 50
c5 outa0_p gnd 2e-12
r6 outa0_n gnd 50
c6 outa0_n gnd 2e-12
r7 outa1_n gnd 50
c7 outa1_n gnd 2e-12
r8 outa1_p gnd 50
c8 outa1_p gnd 2e-12


.END
