******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for TS3A27518
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2009, (C) COPYRIGHT 2009, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
* TS3A27518
* HSPICE NETLIST file built on Tue May 26 16:10:32 CDT 2009
.SUBCKT TS3A27518 PE1 PE2 PE3 PE4 PE5 PE6 PE7 PE8 PE9 PE10 PE11 PE12 PE13
+ PE14 PE15 PE16 PE17 PE18 PE19 PE20 PE21 PE22 PE23 PE24

***PLEASE INCLUDE ONLY ONE PACKAGE***
.INCLUDE 'qfn24.pkg'
* .INCLUDE 'bga24.pkg'

X_TS3A27518__DIE PI1 PI2 PI3 PI4 PI5 PI6 PI7 PI8 PI9 PI10 PI11 PI12 PI13 PI14
+ PI15 PI16 PI17 PI18 PI19 PI20 PI21 PI22 PI23 PI24 TS3A27518__DIE

***PLEASE INCLUDE ONLY ONE PROCESS***
***NOMINAL or STRONG or WEAK***
.LIB 'ts3a27518_process.lib' NOMINAL

**
** No globals were defined outside of .SUBCKT calls...
**

**
** The following netlist has gone through the hspice netlist cleaner,
** version v2.0 - Nov 20 2003
** on Tue May 26 16:10:32 CDT 2009
**

* .width OUT=80
.SUBCKT D_PW ISO MINUS PLUS SUB area=10
D1 PLUS MINUS DPW_A73 AREA='area*518.4e-3'
.ends D_PW
.SUBCKT R_NWELL AVSS MINUS PLUS rw=5 winc=0 r=5 linc=2.96
.param P0='((rw+winc)+((r-2*(323/((rw-307e-3)*720e-3)))/420)*(rw-307e-3))'
D3 AVSS MINUS DNWSUB_P
+ AREA='(666.66666666667e-3*(((P0+5.6)+linc)+winc))*720e-3'
.param P1='(323/((rw-307e-3)*720e-3))'
D2 AVSS PLUS DNWSUB_A
+ AREA='((((((rw-307e-3)*((r-2*P1)/420)+5.6)+linc)+winc)*(rw+winc))/3)*518.4e-3'
.param P2='(323/((rw-307e-3)*720e-3))'
D1 AVSS MINUS DNWSUB_A
+ AREA='((((((rw-307e-3)*((r-2*P2)/420)+5.6)+linc)+winc)*(rw+winc))/3)*518.4e-3'
.param P3='((rw+winc)+((r-2*(323/((rw-307e-3)*720e-3)))/420)*(rw-307e-3))'
D4 AVSS PLUS DNWSUB_P
+ AREA='(666.66666666667e-3*(((P3+5.6)+linc)+winc))*720e-3'
RH2 S2 MINUS '323/(rw*720e-3-221e-3)' scale=1.095 TC1=2.95E-03 TC2=1.205E-05
RB S1 S2 'r-2*(323/(rw*720e-3-221e-3))' scale=1.095 TC1=2.45E-03 TC2=8.50E-06
RH1 PLUS S1 '323/(rw*720e-3-221e-3)' scale=1.095 TC1=2.95E-03 TC2=1.205E-05
.ends R_NWELL
.SUBCKT D_NW BN MINUS PLUS area=10
D1 PLUS MINUS DPN_A20 AREA='area*518.4e-3'
D3 BN MINUS DNWSUB_P AREA='(4*SQRT(area*7.5))*720e-3'
D2 BN MINUS DNWSUB_A AREA='(area*7.5)*518.4e-3'
.ends D_NW
.SUBCKT NCH5T AVSS B D G S T l=650e-3 mi=1 wFinger=650e-3
D4 AVSS T DNWSUB_P AREA='((((18.5+l*mi)+1.6*(mi-1))+(9+wFinger))*2)*720e-3'
D3 AVSS T DNWSUB_A AREA='(((18.5+l*mi)+1.6*(mi-1))*(9+wFinger))*518.4e-3'
D1 B T DPWNISO_P AREA='((((15.5+l*mi)+1.6*(mi-1))+(6+wFinger))*2)*720e-3'
D2 B T DPWNISO_A AREA='(((15.5+l*mi)+1.6*(mi-1.0))*(6.0+wFinger))*518.4e-3'
M1 D G S B NCH W='(wFinger*720e-3)*1u' L='(l*720e-3+12e-3)*1u'
+ AD='(((((1.619*(wFinger+350e-3))*(mi+1))/2)*518.4e-3)/mi)*1p'
+ AS='(((((1.619*(wFinger+350e-3))*(mi+1))/2)*518.4e-3)/mi)*1p'
+ PD='((((((1.619+(wFinger+350e-3))*2.0)*720e-3)*(mi+1))/2.0)/mi)*1u'
+ PS='((((((1.619+(wFinger+350e-3))*2.0)*720e-3)*(mi+1))/2.0)/mi)*1u'
+ M='(mi)'
.ends NCH5T
.SUBCKT M_NCH_ISO4 AVSS B D G S CVCC l=600e-3 mi=1 wFinger=1
X__MN1 AVSS B D G S CVCC NCH5T_NCH l='l*1' mi='mi*1' wFinger='wFinger*1'
.ends M_NCH_ISO4
.SUBCKT esd_iec_b CVCC AVSS PAD
X__D1 CVCC AVSS AVSS AVSS D_PW_DPW_A290 area=400
XR1 AVSS AVSS AVSS R_NWELL rw=5 winc=0 r=3e3 linc=0
X__D4 AVSS PAD PAD D_NW_DPN_A405 area=400
X__D5 AVSS PAD PAD D_NW_DPN_A405 area=400
X__D0 AVSS PAD PAD D_NW_DPN_A405 area=400
XMN4 AVSS AVSS PAD AVSS AVSS CVCC M_NCH_ISO4 l=650e-3 mi=100 wFinger=117.4
.ends esd_iec_b
.SUBCKT M_NCH_ISO5 AVSS B D G S T l=650e-3 mi=1 wFinger=5
X__MN1 AVSS B D G S T NCH5T_NCH l='l*1' mi='mi*1' wFinger='wFinger*1'
.ends M_NCH_ISO5
.SUBCKT ntnmos_450_90 AVSS PAD
X__MN3 AVSS PWB S1 PAD S1 NTB M_NCH_ISO5 l=4.65 mi=1 wFinger=6
X__MN1 AVSS PWB PAD S1 AVSS NTB M_NCH_ISO5 l=650e-3 mi=1 wFinger=450
X__MN2 AVSS PWB PAD S1 PWB NTB M_NCH_ISO5 l=650e-3 mi=1 wFinger=90
XR3 AVSS AVSS NTB R_NWELL rw=11 winc=0 r=201 linc=0
XR2 AVSS AVSS PWB R_NWELL rw=11 winc=0 r=201 linc=0
XR1 AVSS AVSS S1 R_NWELL rw=5 winc=0 r=9.5e3 linc=0
.ends ntnmos_450_90
.SUBCKT M_PCH4 B BN D G S l=650e-3 w=650e-3 wFinger=650e-3 mi=1
D2 BN B DNWSUB_P AREA='((((l+2.888)+6)+((w+6)+3.3))*2)*720e-3'
D1 BN B DNWSUB_A AREA='(((2.888+l)+6)*((w+6)+3.3))*518.4e-3'
M1 D G S B PCH W='(wFinger*720e-3)*1u' L='(l*720e-3+12e-3)*1u'
+ AD='(((((1.619*(wFinger+350e-3))*(mi+1))/2)*518.4e-3)/mi)*1p'
+ AS='(((((1.619*(wFinger+350e-3))*(mi+1))/2)*518.4e-3)/mi)*1p'
+ PD='((((((1.619+(wFinger+350e-3))*2.0)*720e-3)*(mi+1))/2.0)/mi)*1u'
+ PS='((((((1.619+(wFinger+350e-3))*2.0)*720e-3)*(mi+1))/2.0)/mi)*1u'
+ M='(mi)'
.ends M_PCH4
.SUBCKT inv_iso AVSS IN OUT CVCC WN=10 WP=30
XMN0 AVSS AVSS OUT IN AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger='WN*1'
X__MP1 CVCC AVSS OUT IN CVCC M_PCH4_PCH l=650e-3 w='WP*1' wFinger='WP*1' mi=1
.ends inv_iso
.SUBCKT sesd_iso AVSS CVCC IN OUT
XR1 AVSS OUT IN R_NWELL rw=17.15 winc=0 r=128 linc=0
XMN0 AVSS AVSS CVCC CVCC S1 CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=25
XMN4 AVSS AVSS S1 OUT OUT CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=25
XMN5 AVSS AVSS OUT AVSS AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=25
.ends sesd_iso
.SUBCKT D_SHKY MINUS PLUS area=100 w=2.5 f=1
D1 PLUS MINUS d1_gsd_27c AREA='area*518.4e-3'
D2 PLUS MINUS DPN_A81 AREA='((area/w)*3+((w+3)*3)*f)*518.4e-3'
.ends D_SHKY
.SUBCKT input_18_en_ioff IN CVCC OUTB AVSS
XR1 AVSS S3 S5 R_NWELL rw=5 winc=0 r=400e3 linc=0
XR0 AVSS AVSS S4 R_NWELL rw=5 winc=0 r=85e3 linc=0
XESD AVSS IN ntnmos_450_90
XMN5 AVSS AVSS S6 S2 AVSS CVCC M_NCH_ISO4 l=2.6 mi=1 wFinger=7.5
XMN4 AVSS AVSS S2 S1 S4 CVCC M_NCH_ISO4 l=2.6 mi=1 wFinger=7.5
XMN6 AVSS AVSS S7 S6 AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=7.5
X__XINV1 AVSS S7 S8 CVCC inv_iso WN=6 WP=12
X__XINV2 AVSS S8 OUTB CVCC inv_iso WN=20 WP=40
XSESD1 AVSS CVCC IN S1 sesd_iso
X__D0 S5 CVCC D_SHKY_d1_gsd_27c area=200 w=2.5 f=2
X__MP2 CVCC AVSS S6 S2 NET62 M_PCH4_PCH l=2.6 w=30 wFinger=7.5 mi=1
X__MP4 CVCC AVSS NET62 S7 CVCC M_PCH4_PCH l=2.6 w=7.5 wFinger=7.5 mi=1
X__MP5 CVCC AVSS S2 S1 S3 M_PCH4_PCH l=2.6 w=8 wFinger=30 mi=1
X__MP3 CVCC AVSS S5 S6 CVCC M_PCH4_PCH l=2.6 w=7.5 wFinger=7.5 mi=1
X__MP1 CVCC AVSS S6 S2 CVCC M_PCH4_PCH l=2.6 w=30 wFinger=7.5 mi=1
X__MP0 CVCC AVSS S7 S6 CVCC M_PCH4_PCH l=650e-3 w=10 wFinger=50 mi=1
.ends input_18_en_ioff
.SUBCKT input_18_ioff IN OUTB CVCC OUT AVSS
XR3 AVSS S3 S5 R_NWELL rw=5 winc=0 r=400e3 linc=0
XR4 AVSS AVSS S4 R_NWELL rw=5 winc=0 r=85e3 linc=0
XESD AVSS IN ntnmos_450_90
XMN6 AVSS AVSS S7 S6 AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=7.5
XMN5 AVSS AVSS S6 S2 AVSS CVCC M_NCH_ISO4 l=2.6 mi=1 wFinger=7.5
XMN4 AVSS AVSS S2 S1 S4 CVCC M_NCH_ISO4 l=2.6 mi=1 wFinger=7.5
XSESD1 AVSS CVCC IN S1 sesd_iso
X__D0 S5 CVCC D_SHKY_d1_gsd_27c area=200 w=2.5 f=2
X__XINV2 AVSS OUT OUTB CVCC inv_iso WN=12 WP=24
X__XINV1 AVSS S7 OUT CVCC inv_iso WN=12 WP=24
X__MP4 CVCC AVSS NET088 S7 CVCC M_PCH4_PCH l=2.6 w=10 wFinger=7.5 mi=1
X__MP2 CVCC AVSS S6 S2 NET088 M_PCH4_PCH l=2.6 w=10 wFinger=7.5 mi=1
X__MP5 CVCC AVSS S2 S1 S3 M_PCH4_PCH l=2.6 w=8 wFinger=30 mi=1
X__MP3 CVCC AVSS S5 S6 CVCC M_PCH4_PCH l=2.6 w=7.5 wFinger=7.5 mi=1
X__MP1 CVCC AVSS S6 S2 CVCC M_PCH4_PCH l=2.6 w=30 wFinger=7.5 mi=1
X__MP0 CVCC AVSS S7 S6 CVCC M_PCH4_PCH l=650e-3 w=10 wFinger=50 mi=1
.ends input_18_ioff
.SUBCKT NAND3_ISO AVSS IN1 IN2 IN3 OUT CVCC WN1=5 WP3=5 WP1=5 WP2=5
XMN0 AVSS AVSS OUT IN1 NET75 CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger='WN1'
XMN1 AVSS AVSS NET75 IN2 NET79 CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger='WN1'
XMN2 AVSS AVSS NET79 IN3 AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger='WN1'
X__MP3 CVCC AVSS OUT IN3 CVCC M_PCH4_PCH l=650e-3 w='WP3*1' wFinger='WP3'
+ mi=1
X__MP1 CVCC AVSS OUT IN1 CVCC M_PCH4_PCH l=650e-3 w='WP1*1' wFinger='WP1'
+ mi=1
X__MP2 CVCC AVSS OUT IN2 CVCC M_PCH4_PCH l=650e-3 w='WP2*1' wFinger='WP2'
+ mi=1
.ends NAND3_ISO
.SUBCKT delay CVCC IN OUT AVSS
XMN7 AVSS AVSS S7 S6 AVSS CVCC M_NCH_ISO4 l=3.4 mi=1 wFinger=5
XMN8 AVSS AVSS OUT S7 AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=5
XMN0 AVSS AVSS S1 IN AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=5
XMN1 AVSS AVSS S2 S1 AVSS CVCC M_NCH_ISO4 l=3.4 mi=1 wFinger=5
XMN6 AVSS AVSS S6 S5 AVSS CVCC M_NCH_ISO4 l=650e-3 mi=1 wFinger=5
XMN5 AVSS AVSS S5 S4 AVSS CVCC M_NCH_ISO4 l=3.4 mi=1 wFinger=5
XMN4 AVSS AVSS S4 S3 AVSS CVCC M_NCH_ISO4 l=3.4 mi=1 wFinger=5
XMN2 AVSS AVSS S3 S2 AVSS CVCC M_NCH_ISO4 l=3.4 mi=1 wFinger=5
X__MP7 CVCC AVSS S5 S4 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP6 CVCC AVSS S6 S5 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP5 CVCC AVSS S7 S6 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP4 CVCC AVSS OUT S7 CVCC M_PCH4_PCH l=650e-3 w=10 wFinger=10 mi=1
X__MP3 CVCC AVSS S4 S3 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP2 CVCC AVSS S3 S2 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP1 CVCC AVSS S2 S1 CVCC M_PCH4_PCH l=3.4 w=10 wFinger=10 mi=1
X__MP0 CVCC AVSS S1 IN CVCC M_PCH4_PCH l=650e-3 w=10 wFinger=10 mi=1
.ends delay
.SUBCKT control_ioff IN1 AVSS CVCC SPNC123 SPNO456 SNNC123 IN2 SPNC456
+ SNNO123 SPNO123 EN SNNO456 SNNC456
XI31 EN CVCC S5 AVSS input_18_en_ioff
XI29 IN1 S2 CVCC S1 AVSS input_18_ioff
XI30 IN2 S4 CVCC S3 AVSS input_18_ioff
X__XINV1 AVSS S10 SNNC123 CVCC inv_iso WN=40 WP=80
X__XINV2 AVSS S10 S14 CVCC inv_iso WN=12 WP=24
X__XINV3 AVSS S14 SPNC123 CVCC inv_iso WN=40 WP=80
X__XINV4 AVSS S11 SNNO123 CVCC inv_iso WN=40 WP=80
X__XINV5 AVSS S11 S15 CVCC inv_iso WN=12 WP=24
X__XINV6 AVSS S15 SPNO123 CVCC inv_iso WN=40 WP=80
X__XINV12 AVSS S17 SPNO456 CVCC inv_iso WN=40 WP=80
X__XINV8 AVSS S12 S16 CVCC inv_iso WN=12 WP=24
X__XINV7 AVSS S12 SNNC456 CVCC inv_iso WN=40 WP=80
X__XINV9 AVSS S16 SPNC456 CVCC inv_iso WN=40 WP=80
X__XINV10 AVSS S13 SNNO456 CVCC inv_iso WN=40 WP=80
X__XINV11 AVSS S13 S17 CVCC inv_iso WN=12 WP=24
X__XNAND4 AVSS S3 S9 S5 S13 CVCC NAND3_ISO WN1=30 WP3=30 WP1=30 WP2=30
X__XNAND2 AVSS S1 S7 S5 S11 CVCC NAND3_ISO WN1=30 WP3=30 WP1=30 WP2=30
X__XNAND1 AVSS S2 S6 S5 S10 CVCC NAND3_ISO WN1=30 WP3=30 WP1=30 WP2=30
X__XNAND3 AVSS S4 S8 S5 S12 CVCC NAND3_ISO WN1=30 WP3=30 WP1=30 WP2=30
XDELAY4 CVCC SPNC456 S9 AVSS delay
XDELAY3 CVCC SPNO456 S8 AVSS delay
XDELAY1 CVCC SPNO123 S6 AVSS delay
XDELAY2 CVCC SPNC123 S7 AVSS delay
.ends control_ioff
.SUBCKT R_NWELL_schematic BN MINUS PLUS rw=5 winc=0 r=5 linc=2.96
.param P4='((rw+winc)+((r-2*(323/((rw-307e-3)*720e-3)))/420)*(rw-307e-3))'
D3 BN MINUS DNWSUB_P
+ AREA='(666.66666666667e-3*(((P4+5.6)+linc)+winc))*720e-3'
.param P5='(323/((rw-307e-3)*720e-3))'
D2 BN PLUS DNWSUB_A
+ AREA='((((((rw-307e-3)*((r-2*P5)/420)+5.6)+linc)+winc)*(rw+winc))/3)*518.4e-3'
.param P6='(323/((rw-307e-3)*720e-3))'
D1 BN MINUS DNWSUB_A
+ AREA='((((((rw-307e-3)*((r-2*P6)/420)+5.6)+linc)+winc)*(rw+winc))/3)*518.4e-3'
.param P7='((rw+winc)+((r-2*(323/((rw-307e-3)*720e-3)))/420)*(rw-307e-3))'
D4 BN PLUS DNWSUB_P AREA='(666.66666666667e-3*(((P7+5.6)+linc)+winc))*720e-3'
RH2 S2 MINUS '323/(rw*720e-3-221e-3)' scale=1.095 TC1=2.95E-03 TC2=1.205E-05
RB S1 S2 'r-2*(323/(rw*720e-3-221e-3))' scale=1.095 TC1=2.45E-03 TC2=8.50E-06
RH1 PLUS S1 '323/(rw*720e-3-221e-3)' scale=1.095 TC1=2.95E-03 TC2=1.205E-05
.ends R_NWELL_schematic
.SUBCKT sesd1 P1 P2 AVSS CVCC
XMN1 AVSS AVSS P2 P2 NET6 CVCC M_NCH_ISO4 l=750e-3 mi=1 wFinger=25
XMN0 AVSS AVSS NET6 P1 P1 CVCC M_NCH_ISO4 l=750e-3 mi=1 wFinger=25
.ends sesd1
.SUBCKT bit_ioff CVCC NC A B AVSS PC
XR2 AVSS NET104 CVCC R_NWELL_schematic rw=5.35 winc=0 r=450 linc=0
X__D0 AVSS NET141 CVCC D_NW_DPN_A81 area=60
X__D1 AVSS NET125 CVCC D_NW_DPN_A81 area=60
XMN5 AVSS AVSS S5 NET0150 AVSS CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=20
XMN6 AVSS AVSS S3 S5 AVSS CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=40
XMN7 AVSS AVSS S1 NET0150 S3 CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=80
XMN8 AVSS AVSS S2 NET0150 S3 CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=80
XMN14 AVSS AVSS NET62 NET104 AVSS CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=10
XMN15 AVSS AVSS NET107 NET62 AVSS CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=25
XMN9 AVSS S3 B NC A CVCC M_NCH_ISO4 l=650e-3 mi=52 wFinger=23
XMN16 AVSS AVSS NET0150 NET130 AVSS CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=25
XMN11 AVSS AVSS NET130 NET104 PC CVCC M_NCH_ISO4 l=950e-3 mi=1 wFinger=200
XI28 A NET130 AVSS CVCC sesd1
XI31 NC B AVSS CVCC sesd1
XI16 NET0150 A AVSS CVCC sesd1
XI17 NET0150 B AVSS CVCC sesd1
XI19 A NET104 AVSS CVCC sesd1
XI20 B NET104 AVSS CVCC sesd1
XI30 NC A AVSS CVCC sesd1
XI29 B NET130 AVSS CVCC sesd1
X__D4 NET130 NET101 D_SHKY_d1_gsd_27c area=40 w=2.5 f=1
X__D3 NET130 NET99 D_SHKY_d1_gsd_27c area=40 w=2.5 f=1
XR3 AVSS NET107 S3 R_NWELL rw=5.35 winc=0 r=500 linc=0
XR1 AVSS S2 B R_NWELL rw=5.35 winc=0 r=500 linc=0
XR0 AVSS S1 A R_NWELL rw=5.35 winc=0 r=500 linc=0
X__MP10 CVCC AVSS NET0150 NET130 CVCC M_PCH4_PCH l=950e-3 w=50 wFinger=20
+ mi=1
X__MP5 NET141 AVSS NET125 NET104 NET130 M_PCH4_PCH l=950e-3 w=50 wFinger=25
+ mi=1
X__MP3 NET141 AVSS NET130 NET0150 NET147 M_PCH4_PCH l=950e-3 w=50 wFinger=25
+ mi=1
X__MP4 NET141 AVSS NET101 NET104 A M_PCH4_PCH l=950e-3 w=50 wFinger=100 mi=1
X__MP7 NET141 AVSS NET99 NET104 B M_PCH4_PCH l=950e-3 w=50 wFinger=100 mi=1
X__MP6 NET130 AVSS NET130 NET104 NET62 M_PCH4_PCH l=950e-3 w=50 wFinger=25
+ mi=1
X__MP9 NET125 AVSS PC NET62 NET130 M_PCH4_PCH l=950e-3 w=50 wFinger=300 mi=1
X__MP2 NET147 AVSS B NET130 A M_PCH4_PCH l=650e-3 w=3.2e3 wFinger=40 mi=80
X__MP0 CVCC AVSS S5 NET0150 CVCC M_PCH4_PCH l=950e-3 w=50 wFinger=40 mi=1
.ends bit_ioff
.SUBCKT inv2_0p9_iso AVSS IN OUT PWR WN=10 WP=30
XMN0 AVSS AVSS OUT IN AVSS PWR M_NCH_ISO4 l=900e-3 mi=1 wFinger='WN*1'
X__MP1 PWR AVSS OUT IN PWR M_PCH4_PCH l=900e-3 w='WP*1' wFinger='WP*1' mi=1
.ends inv2_0p9_iso
.SUBCKT BigFET_LLNEW AVSS BUS LP1=72 WP1=100
XMN1 AVSS AVSS BUS S4 AVSS BUS M_NCH_ISO4 l=900e-3 mi=1 wFinger=4.5e3
X__XINV0 AVSS S2 S3 BUS inv2_0p9_iso WN=36 WP=72
X__XINV1 AVSS S3 S4 BUS inv2_0p9_iso WN=180 WP=360
XR1F AVSS S9 S11 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1G AVSS S10 S9 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1H AVSS AVSS S10 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1C AVSS S5 S7 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1E AVSS S11 S8 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1B AVSS S6 S5 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1D AVSS S7 S8 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
XR1A AVSS S2 S6 R_NWELL_schematic rw=5 winc=0 r=12.5e3 linc=0
X__MP1 BUS AVSS BUS S2 BUS M_PCH4_PCH l='LP1' w='WP1*1' wFinger='WP1' mi=1
.ends BigFET_LLNEW

** Added by cleaner script...
.SUBCKT TS3A27518__DIE COM1 CGND COM2 COM3 CVCC COM4 COM5 NO1 COM6 NO2 IN2
+ NO3 NO6 NO4 NO5 NC5 EN NC4 NC6 NC3 IN1 NC2 NC1 CGND__0
.PROT freelib
5a2Z[7-u#/js;B-i:'%ep$v,C'/25B]+):fJ5H#uC(1y)e-u>9%J;X5i#'%s$B-,(2/e5BvwC'f:9H]uC:xJ5ejH>(%J)[
9K'O2:$S2 o9>!8Y/S(9PA$x9Q
7W*h$S9/%9=p/9# 0[X(/Y/#9KD/L
)CJM9>P[s#$6B028s3w9Bpgh0Gs[6
e(/Y\vm9>p[S#$6b028M;W9bPGH0gS[6
e(/Y\v)9>p[S#$6b028M5W9bPGH0gS[6
e(/Y\vP9>p[S#$6b028MRW9bPGH0gS[6
e(/Y\v>9>p[S#$6b028MVW9bPGH0gS[6
e(/Y\/c9>p[S#$6b028S-W9bPGH0gS[6
e(/Y\vc9>p[S#$6b028M-W9bPGH0gS[6
e(/Y\/m9>p[S#$6b028S;W9bPGH0gS[6
e(/Y\/)9>p[S#$6b028S5W9bPGH0gS[6
e(/Y\/P9>p[S#$6b028SRW9bPGH0gS[6
e(/Y\/>9>p[S#$6b028SVW9bPGH0gS[6
>j)7\v39=p/9#/-71-s.:ry
k128s3w'\0u$sQR(eUi ]8
/C9[a57[y<BxaY]jXM]_1l
s;w+m%2G+zk:kA1p!;Tt7z
a)7\/M9=P/9#/-71-S.:RY
kv28m;w'\0u$sQR(eUi ]8
/)9[a)7[y<BxaY]jXM]_1l
sUw+m/2G+zk:kA1p!;Tt7z
a*7\/p9=P/9#/-71-S.:RY
kf28mrw'\0u$sQR(eUi ]8
/3/xZ[$#$6B02[_7+hu$\K[
gp39[d97[Y<bXAy]Jxm]_1L
s3u:k.o)7[y<BxaY]jXM]_1l
s33:k.o07[y<BxaY]jXM]_1l
s3i:k.o97[y<BxaY]jXM]_1l
s3H:k.o77[y<BxaY]jXM]_1l
s3J:k.o57[y<BxaY]jXM]_1l
s3L:k.oS7[y<BxaY]jXM]_1l
s-+:*[2G+zk:kA1p!;Tt7z
a5=##+[x;<9zw%)Y:zJ*[x6
>j57c c9=p/9#/-71-s.:ry
38T)7[y<BxaW\3w+X[oW9/ip/dep[
4)<%>d>h#$6b02[MkI:=7z>MZS>I1G;x8
o9BpaW\5w'\0u$st9)9['8\tkQ:v:.ejq
7*0 [MkU:5-U/7gvu'XzJ#kv<C/+P6]+y
32uvst9p9=P/9#/0ov28%\90Bds0X/,(6
e(/YgvuUX;<9ZW%Mm)$#s uM0G)<JS#/Z
Fhejw!= 2G+zk:k-a[7z4:Bh2/=##+'xu97z3:B*2t##k>90J$st  y.L.4t[t6
e/H%\/39>p[S#K39[A77gvu[X;<9ZW<IX/H%/#0j_0
'-c2+MV2[+g/:b/28MRW%Mm+$19K<90v$-c2qW.\ [
4f!x[A07gY%KXU57\/P9>d><#$6b02/$#f!xD7wd:Q
7-8'8S5W%\>A$9-W+KJ2[Mkh:5-U/7Zh:-8'.4T[T6
e/H%\v)9>p[S#K>9[d97gvu2X;<9ZW<SX/H%/#0j_0
'-c2+M/2[+g/:b/28MVW%MmS$19K<90v$-c2qW.\ [
4f!x[A)7gY%KXU57\/>9>d>h#$6b02/$#f!xD7wd:Q
7-8'8S-W%\>A$93W+K%2[MkU:5-U/7Z4:-8'.4T[T6
e/H%\v39>p[S#Km9[d77gvu[X;<9ZW<$X/H%/#0j_0
'-c2+M%2[+g/:bu28M-W%Mmj$19K<90t$-c2qW.\ [
4f!x[As7gY%KXU77\/m9>d>j#$6b02/<#f!xD7wd:Q
7-8'8M;W%\>A$9;W+Mu2[Mk3:5-U/7Zj:-8'.4T[T6
e/HO:) 9=p/9#/6K>2X42[9xDl3#<M:r$hybV+:d$hyjJQ
H*[ /7sKm5%t0=ySq%8(L
[
8
q
5AZ
[n7S*99_D3,tm!=G2z9$F%47u$u<599= v0dw[<x'd0#/f*=Zt8#/0oM;8y+q
5AX'D0Z):56($8<%RW6(V7c :M6 T8#2096(>M9):x;($9*#%*DOwY<=:]=3g\<29Y0-L
F,q
y
axoWyC[!*p2j/<whB4/[gSwOc0>M2#9!=4u$.%!<90ihs<sUmp(3_dPQN0 .BU/:56(G_3+(6
92,_-xP9_*77\) r8UJ7:v;97>T7Dpqn0 .bu/:b$7[0#90%2lZ!+Q
Hb4/[GsWoC0>m2/;3CgUV6-j%9m78rZW2r4U$1')') :P7X(cEV2 _3Q
o[XI3rZWuW[M/7Dpqn0 .bu/:56(g_7$;*=[0=yx>*\)k[
DU:]iM/7k#+002V.\S'S 2g8<$-7T=g8<$=d][st)bi8uKNjF<T;9+7>+I9!u1L
!< OBx .9h\8cpH.oz;Q'*al
[
8
<:o. hDC)O97>t7+kr->]j7Ks2k;s$-#F+9p2A7zwf)j+p0.3:DAy0X<6M90ihs<sUmp(3_*/A6
92,dc Z*6*9<J)*UXOH_3W+*7lH9sWTM62J/<W2K;2/.c/99mdV0%xHEZ
-/R0/.Xxo..G*>c$ad70w[=x $o#k:RAy0X<6M9C*9<j)*ux4 4\D9yAy0X<6M9M7Y=8
;C93Z$-#;+D0mx6*w'y2;Y])BlVI$5!YLE;:y4T)BI8jkOJ+3b;9J4FUu(*\)K[
Dp:-[2X7D ib4/.1#$;*=*kK)bcEHv*t%.$2][RKX_);:)ZjF.5I vZh<6m7Z
o77dwz902x7*/A9C*Kkx[!=G(:FUu(*\)4F3!x9I*Kk%<W'1(=JAPC*\)4F3!x6
:2gYqrLvT=R=+h3(9=,dc Z*6$s<J)*U]KNKk#$[]K-bF<P[H-)0.3BQm74f3tX6
:2g9qrLvT=R=+h3(9=,dc Z*6$s<J)*U]KNKk#$[]K-bF<P[H-)0.3BQm74f3tX6
:26YqrLvT=RK3x)[F$RU:#+n23ojR+9!uK4f-x(;9t5x<6m;9=>4apB;LjZxF'uW][7r7Q
$9$Uy])bLvT=7!5p#8T4 4\d9Y:)0x<6m;][5!J.5$%:T3;.5vm7o=F.='B:45k#BA Mk[
aWu)y=>4Fry
e2Zv9#9Q]>>)6*/A6
Z
0
N7kvoW_7TY#2a*X-/r0/.xXz[/R2:5-U/70Wo9g2/7sWF)J+P0.3:O8*77X[!=g(:_54(*\)L
F#k2w>(.\t;9RAZ[/# 9XI7/%#[0yx'd0# %Fxu64G):o. t,+Xh6
BU\-g\ 9[AD<sS+K;2g+ZK:-X $O#K:xXly$R+9!u2>4qp:d_78O<5-2V:T3;Q
o:X;<9ZW 9Pz,9$fq]X;:0[(XvT=R=yxP8i[>4F_3EJ[R\c63;]$REaMTW[!T8F.5'][(bJ)*Uy0
Vj#$6b02J7D ib4/.1#$;*=*kK)b3SB+o,,9!;:hZ$,buW\h4C,b#8c\H#2);;][0=yx>*\)k[
Dp:-X'$Y*M+W0d..#$;*=*kK)bL[V-0t%<uW]$7!5<LO857CF_L2:4 4\d9Y]KNbF<w'1(=j7Q
o'X/$%#;2d[7/M/$:56(g_7bLv +Z<a=5O8Ko=+h5vm7==++B;9=9!J_ij8za0'.BAVh*!V)*Uy0
>=#;:nXU$-# %fX4y])MTW[!T8,jc/25sC,pR7Xly])=5$%:T3;_3'25sC,pR7Z
$$1d(xVt=rk3X)[f[ru:#+N23OJr+9!Uk4F)9!8 k45-.5i VzH<6M;lohc,P27z
$$1z(xVt=rk3X)[f[ru:#+N23OJr+9!Uk4F)9!8 k45-.5i VzH<6M;lohc,P27z
$$.d(xVt=rk)Ph2 eOkx[!=G(:T;4(*\)4c,uh/][(Bj)*u][r\C_3;]w5!j.=o8kn=$RY
8xi/_7BlVt=r=+H3(:=,DC z*6$S<j)*u]knB++ba*Jp0.3batohT3.bq%-pcE9!;9H\]8
_:oA1r\C.x6
B(8YZW+K;+J6\/a6
Z
0
N7kvoW_7TY#2a*X-/r0/.xX .#XW[=XOH#$K:]iM/7Zt!K2G>MD)F)PI86[U(9=3T1qp(9[(J,cK 6
92 M'W f22V.\S''12/.c/99mdV0%xHEZ
-/R0/.Xx .#xsO][gGBjw[=xoh#$k:]Im/7[595AHp[
Dp:]iM/7k#+002V.\S''12g8<$-7=3T1,43SBST3;ry
%U2x##9!=4u$y\m<03g67[595A1rH,k4y7=G8<$5$b+4c,JC/25S]8
;C93Z$\C rBx 8uz![c=2G8<$-7t;:0[<Wevkn<3Lh:25S]8
X9=pu$y/ Icpi86[u(6
Z
-/R0/.Xx .#xsO][gGHj4:-[2>4\!<9$L\9#$;*=*7X8
;39$L\9#9!=4u$y* Q5/:07[595A1G8<$5i VzH<6M7z
 S70 :o8Z\9#;+D0mx6*w'y2;Y])i5Bn3jk[5959Tz<f.5$%:t3;RY
%%2x##9!=4u$y\m<03gG7[595A1r1')'a*-0c,43sbst3;RY
e2Zv9#;Q=Cgv.\s':1+l
[
+KR->]J7DS+dD 6#/$e[X/87k#+0026,$K:56(g_3+y
% 26,$k:o8Z\9#;2=d;*=#$;*=*K1')'avH*!v)*uY0
Vj#f+9m78rZWo=cU\-/t:56(g_7b>A0n:%)$;*=[(!R.BA*jP0.3X6
Pj$-\WuW[M/7D ib4/.1#$;*=*kK[5959tZ<F<P[H-)0.3X6
B(8YZWoC[4.Y* q5HhL
[
8
<:o. hDC)O97>t7+kr->]j7ds2Dx7/m#9!=4u$.%!<90mx7zT!k2g>md)f)pi,6[JM9=3t1QP(6
9280s=!b72 M'W f22V.XS'$u2/.c/99mdV0%xHEZ
-/R0/.Xx ..xsO]CgGi;q
$98Uw7k#+0026,$K:b4/$1')') :L
y3w2R4u$\C rBx 6u/$Wux;:0[(x56(GFrPEe/(=J7q
H*[ /7DS2dD 6U/$wUZ
0
N7kvoW_7TY#2a*X-/r0/.xX ..XW!b.2>4\!<9$l\9#KR-XU64g)qO. T,q;2dD;5EJW'Y2;y=JQ
59[(J,cK 9_d:7s*99PI,6[,(90IHS<WuMP(3!+xy
e0mxsW2:%di,6dTIc=J;X8
_:w0D$\C rBxi3Rzw<032G8<$-[10
V=#tF002>4\!<9PI,6[U#/X;:0[(X56(gfRpeE/(=j7Q
H*[ /7DS2dD 6U/$c(10
L
[
+!+]6dJ[
.UNPROT

.ENDS TS3A27518
