******************************************************************************
* *
* TEXAS INSTRUMENTS INCORPORATED
* Standard Linear and Logic Group
* HSPICE Model for SN74CBTU4411
* PROPERTY OF TEXAS INSTRUMENTS INCORPORATED. UNAUTHORIZED
* REPRODUCTION AND/OR DISTRIBUTION IS STRICTLY PROHIBITED.
*
* THIS PRODUCT IS PROTECTED UNDER COPYRIGHT LAW.
* CREATED 2007, (C) COPYRIGHT 2007, TEXAS INSTRUMENTS
* INCORPORATED, ALL RIGHTS RESERVED
*
* UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE
* CONTRARY, TEXAS INSTRUMENTS (TI) IS PROVIDING THE IBIS
* MODELS AND WITHOUT ANY WARRANTY, EXPRESSED OR
* IMPLIED. TI ASSUMES NO LIABILITY FOR:
* 1) THE ACCURACY OF THE HSPICE MODELS PROVIDED TO YOUR
* COMPANY;
* 2) THE PROPER FUNCTIONING OF THESE HSPICE MODELS IN YOUR
* DESIGN OR FOR ANY RESULTING APPLICATIONS; OR
* 3) INFRINGEMENT OF PATENTS, COPYRIGHTS OR INTELLECTUAL
* PROPERTY RIGHTS RESULTING FROM YOUR USE OF THESE HSPICE
* MODELS.
*
* TI PROVIDES HSPICE MODELS AS A SERVICE TO OUR CUSTOMERS.
* YOU AND YOUR COMPANY SHALL NOT DISTRIBUTE, SELL OR GIVE
* THESE MODELS TO ANYONE ELSE WITHOUT PRIOR WRITTEN
* PERMISSION FROM TI.
*
* TI RESERVES THE RIGHT TO MAKE CHANGES TO OUR PRODUCTS OR
* TO DISCONTINUE ANY SEMICONDUCTOR PRODUCT OR SERVICE
* WITHOUT NOTICE, AND ADVISES OUR CUSTOMERS TO OBTAIN THE
* LATEST VERSION OF RELEVANT INFORMATION TO VERIFY, BEFORE
* PLACING ORDERS, THAT THE INFORMATION BEING RELIED ON IS
* CURRENT.
*
* PLEASE BE AWARE THAT YOUR RECEIPT AND USE OF THE HSPICE
* INFORMATION PROVIDED SHALL SERVE AS ACCEPTANCE OF THESE
* TERMS AND CONDITIONS. IF YOU DO NOT ACCEPT THESE TERMS,
* YOU SHOULD RETURN OR DESTROY THE HSPICE MODELS AND ANY
* OTHER ACCOMPANYING INFORMATION IMMEDIATELY.
************************************************************************
**** HSPICE EXECUTION OPTIONS ****
************************************************************************
*
.OPTIONS POST $ Enables HSPLOT interface
.OPTIONS ACCT OPTS $ Prints stats & option values used
.OPTIONS SPICE=1 $ Forces Berkeley compatibility
.OPTIONS GMIN=1E-10 $ Lowest allowable conductance values
.OPTIONS GMINDC=1E-10
.OPTIONS ITL1=400 $ Maximum DC iteration limit
.OPTIONS ITL4=40 $ Maximum transient iterations/timestep
.OPTIONS ITL5=0 $ No limit to total transient iterations
***********************************************************************
.OPTIONS search='./'

***********************************************************************
******Top level Subcircuit call (device call)
***********************************************************************
* .INCLUDE 'sn74cbtu4411.inc'
X__SN74CBTU4411 S1 S0 TC EN VREF GND VBIAS X_2D10 X_3D10 H10 X_0D10 X_1D10
+ GND X_3D9 X_1D9 H9 X_0D9 X_2D9 GND X_3D8 X_2D8 H8 X_1D8 X_0D8 X_3D7 X_2D7 H7
+ X_1D7 X_0D7 GND X_3D6 X_2D6 H6 X_0D6 X_1D6 X_3D5 VCC X_2D5 H5 X_0D5 X_1D5
+ X_3D4 X_2D4 X_1D4 H4 GND X_0D4 X_3D3 X_2D3 X_1D3 H3 X_0D3 X_3D2 X_2D2 H2
+ X_1D2 X_0D2 GND X_3D1 X_2D1 H1 X_0D1 X_1D1 X_1D0 X_3D0 H0 X_2D0 X_0D0 GND VCC
+ VCC DQS_EN VPP SN74CBTU4411
*** PULSE PARAMETERS ***
.param PDELAY1=5ns $ delay of 1st pulse
.param PVIN='PVCC' $ input voltage

*** TRANSIENT START & START PARAMETERS ***
.param PSTART='PDELAY1' $ time input starts to transition.
.param PSTOP='PSTART+20n' $
.TRAN 0.05n 'PSTOP' 'PSTART' 0.05n
.PRINT TRAN v(DATA)

* SET CONTROL INPUTS TO ENABLE OUTPUT
VC0 TC 0 DC 0
VC1 S0 0 DC 0
VC2 S1 0 DC 0
VC3 EN 0 DC 0
VC4 DQS_EN 0 DC 'PVCC'


*** SET INPUT AND TEST OUTPUT TO GO LOW ****
VP0 H0 GND PULSE 0 'PVCC' 5ns 2ns 2ns 8ns 20ns

* CHANGE TO THE OUTPUT NODE
VDATA X_0D0 DATA DC 0
RLOAD DATA GND 500

* VOLTAGE SUPPLIES
VVBIAS VBIAS 0 DC 0.54V
vvpp vpp 0 dc 4.2V

.param PVCC=1.8
.param PGND=0v
VVCC VCC 0 'PVCC'
VGND GND 0 'PGND'
VVREF VREF 0 0.9

.TEMP 40

* RESISTORS TO PREVENT DANGLING NODES
* R1G_1 S1 0 1G
* R1G_2 S0 0 1G
* R1G_3 TC 0 1G
* R1G_4 EN 0 1G
* R1G_5 VREF 0 1G
* R1G_6 GND 0 1G
* R1G_7 VBIAS 0 1G
R1G_8 X_2D10 0 1G
R1G_9 X_3D10 0 1G
R1G_10 H10 0 1G
R1G_11 X_0D10 0 1G
R1G_12 X_1D10 0 1G
* R1G_13 GND 0 1G
R1G_14 X_3D9 0 1G
R1G_15 X_1D9 0 1G
R1G_16 H9 0 1G
R1G_17 X_0D9 0 1G
R1G_18 X_2D9 0 1G
* R1G_19 GND 0 1G
R1G_20 X_3D8 0 1G
R1G_21 X_2D8 0 1G
R1G_22 H8 0 1G
R1G_23 X_1D8 0 1G
R1G_24 X_0D8 0 1G
R1G_25 X_3D7 0 1G
R1G_26 X_2D7 0 1G
R1G_27 H7 0 1G
R1G_28 X_1D7 0 1G
R1G_29 X_0D7 0 1G
* R1G_30 GND 0 1G
R1G_31 X_3D6 0 1G
R1G_32 X_2D6 0 1G
R1G_33 H6 0 1G
R1G_34 X_0D6 0 1G
R1G_35 X_1D6 0 1G
R1G_36 X_3D5 0 1G
* R1G_37 VCC 0 1G
R1G_38 X_2D5 0 1G
R1G_39 H5 0 1G
R1G_40 X_0D5 0 1G
R1G_41 X_1D5 0 1G
R1G_42 X_3D4 0 1G
R1G_43 X_2D4 0 1G
R1G_44 X_1D4 0 1G
R1G_45 H4 0 1G
* R1G_46 GND 0 1G
R1G_47 X_0D4 0 1G
R1G_48 X_3D3 0 1G
R1G_49 X_2D3 0 1G
R1G_50 X_1D3 0 1G
R1G_51 H3 0 1G
R1G_52 X_0D3 0 1G
R1G_53 X_3D2 0 1G
R1G_54 X_2D2 0 1G
R1G_55 H2 0 1G
R1G_56 X_1D2 0 1G
R1G_57 X_0D2 0 1G
* R1G_58 GND 0 1G
R1G_59 X_3D1 0 1G
R1G_60 X_2D1 0 1G
R1G_61 H1 0 1G
R1G_62 X_0D1 0 1G
R1G_63 X_1D1 0 1G
R1G_64 X_1D0 0 1G
R1G_65 X_3D0 0 1G
* R1G_66 H0 0 1G
R1G_67 X_2D0 0 1G
* R1G_68 X_0D0 0 1G
* R1G_69 GND 0 1G
* R1G_70 VCC 0 1G
* R1G_71 VCC 0 1G
* R1G_72 DQS_EN 0 1G

.END
