************************************************************************
*Standard Linear and Logic, Texas Instruments
************************************************************************
*          Property of Texas Instruments Incorporated.  Unauthorized   *
*          reproduction and/or distribution is strictly prohibited.    *
*                                                                      *
*          This product is protected under copyright law.              *
*          Created 2003, (C) Copyright 2003, Texas Instruments Inc.,   *
*          All Rights Reserved                                         *
*                                                                      *
*          UNLESS THERE IS A SIGNED, WRITTEN AGREEMENT TO THE          *
*          CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE   *
*          MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR       *
*          IMPLIED.  TI assumes no liability for:                      *
*          1) the accuracy of the SPICE models provided to your        *
*             company;                                                 *
*          2) the proper functioning of these SPICE models in your     *
*             design or for any resulting applications; or             *
*          3) infringement of patents, copyrights or intellectual      *
*             property rights resulting from your use of these         *
*             SPICE models.                                            *
*                                                                      *
*          TI provides SPICE Models as a service to our customers.     *
*          You and your company shall not distribute, sell or give     *
*          these models to anyone else without prior written           *
*          permission from TI.                                         *
*                                                                      *
*          TI reserves the right to make changes to our products or    *
*          to discontinue any semiconductor product or service         *
*          without notice, and advises our customers to obtain the     *
*          latest version of relevant information to verify, before    *
*          placing orders, that the information being relied on is     *
*          current.                                                    *
*                                                                      *
*          Please be aware that your receipt and use of the SPICE      *
*          information provided shall serve as acceptance of these     *
*          terms and conditions.  If you do not accept these terms,    *
*          you should return or destroy the SPICE models and any       *
*          other accompanying information immediately.                 *
************************************************************************
*
* SLL APPLICATIONS
* DATE : AUGUST 2003
*NOTE:
*This is the user's file.Refer to the read.me file before you proceed.
*
************************************************************************
****                HSPICE EXECUTION OPTIONS                        ****
************************************************************************
*
    .OPTIONS POST           $ Enables HSPLOT interface
    .OPTIONS ACCT OPTS      $ Prints stats & option values used
    .OPTIONS SPICE=1        $ Forces Berkeley compatibility
    .OPTIONS GMIN=1E-10     $ Lowest allowable conductance values
    .OPTIONS GMINDC=1E-10
    .OPTIONS ITL1=400       $ Maximum DC iteration limit
    .OPTIONS ITL4=40        $ Maximum transient iterations/timestep
    .OPTIONS ITL5=0         $ No limit to total transient iterations
    .OPTIONS search='./'
***********************************************************************
* 
***********************************************************************

*ENCRYPTED DEVICE NET-LIST


X_DEVICE_SELECTOR  0 CB3Q3306AINC  $DEVICE NETLIST


*ENCRYPTED PROCESS MODELS

X_PROCESS_SELECTOR 0 NOMINAL_50B29.1_L49INC $50B29.1 NOMINAL LEVEL 49 PROCESS MODEL
*X_PROCESS_SELECTOR 0 STRONG_50B29.1_L49INC  $50B29.1 STRONG  LEVEL 49 PROCESS MODEL
*X_PROCESS_SELECTOR 0 WEAK_50B29.1_L49INC    $50B29.1 WEAK    LEVEL 49 PROCESS MODEL

*UN-ENCRYPTED RESISTOR MODEL

.include 'res_nominal'
*.include 'res_strong'
*.include 'res_weak'

***********************************************************************
*PACKAGE FILE. PLEASE CHOOSE ONLY ONE PACKAGE FILE
***********************************************************************


.INCLUDE 'TSSOP8.PKG'

***********************************************************************
* Refer to the data sheet for node description.
***********************************************************************
******Top level Subcircuit call (user's nodes)
***********************************************************************

xCB3Q3306A  x_1A x_1B x_2A x_2B x_1NOE x_2NOE CVCC CGND CB3Q3306A


***********************************************************************
******Supply Voltages
***********************************************************************
v_vcc     cvcc      0     DC     3.3
v_gnd     cgnd      0     DC     0

*************** ********************************************************
******Subcircuit for package connection
***********************************************************************
.subckt CB3Q3306A 
+p_1a
+p_1b
+p_2a
+p_2b
+p_1noe
+p_2noe
+p_cvcc
+p_CGND


X_PIN_1		p_1noe		s_1noe	TSSOP8_01
X_PIN_2		p_1a		s_1a	TSSOP8_02
X_PIN_3		p_1b		s_1b	TSSOP8_03
X_PIN_4		p_CGND		CGND	TSSOP8_04
X_PIN_5	        p_2a		s_2a	TSSOP8_05
X_PIN_6	        p_2b		s_2b	TSSOP8_06
X_PIN_7 	p_2noe		s_2noe	TSSOP8_07
X_PIN_8 	p_CVCC		CVCC	TSSOP8_08
xCB3Q3306A  s_1a s_1b s_2a s_2b s_1noe s_2noe CVCC CGND cb3q3306a__bit


 
.ENDS CB3Q3306A 




***********************************************************************


.TRAN     10ns 4.1US START=4US




Vx_1a x_1A cgnd pulse ( 0 5 5ns 1ns 1ns 6ns 12.5ns)
Vx_2a x_2A cgnd pulse ( 0 5 5ns 1ns 1ns 6ns 12.5ns)

Rload_x_1b x_1B cgnd 1k
Cload_x_1b x_1B cgnd 15p

Rload_x_2b x_2B cgnd 1k
Cload_x_2b x_2B cgnd 15p

VNOE1     x_1NOE  CGND DC 0
VNOE2     x_2NOE  CGND DC 0


.END
                                         




