# Setting up the Repository File structure
**REPOSITORY EXAMPLES: https://bitbucket.itg.ti.com/projects/MODELS**

![](https://confluence.itg.ti.com/download/attachments/234095547/image2019-6-20_10-44-39.png?version=1&modificationDate=1561045479912&api=v2)

----------

# What to include and what to exclude from your model to be released to ti.com
**Include**
- PSpice model: 
    - A .ZIP file that includes the .lib, .olb, .dsn, ... (We recommend using PSpice's archive function to generate the zip file. This will pull in referenced files outside the project directory as well as exclude unnecessary files left from running sinulations).
- TINA model: 
    - A .TSC file if a test circuit is released. The model instantiated in the TSC files can be exported (as a .TSM file) and used in other designs. If releasing only a .TSM file, zip that into a .zip file for release.
- IBIS model: 
    - .Zip file containing the .ibs file. Do not release the .ibs file as-is because IBIS is sensitive to file name.
- Simplis model: 
    - .sxcmp file.

**Exclude**
- Do not include 3rd party model files
- Do not include copyrighted material including images
- If this is an encrypted model, make sure that the unencrypted .lib file is not included in the .zip file

----------
# Where to store the model files to be released to ti.com
If this repository was created to store a model that supports a single GPN, the file being published to the web should be stored at the repository root. 

If this repository was created to store models that support a family of parts and folders for individual GPNs have been create under the repository, model files being published to the web for a GPN should be stored at the root level of the corresponding GPN folder. Example: https://bitbucket.itg.ti.com/projects/MODELS/repos/example_part_family/browse

----------

# What to include in your (unencrypted) model to be released directly to a customer
Read the tutorial here: https://confluence.itg.ti.com/x/uwP0DQ

----------
# Where to store other files

The main purpose of this repository is to store files used/created during the model development for future reference should a bug is discovered or a revision is required. For example, specs/documentation, user guide/test benches and other things. 

These files should be grouped by the simulator. "Development-NameOfSimulator" folders should be created at the root level of the repository (if the repository supports a single GPN) or the GPN folders (if the repository supports a family of parts). Example: https://bitbucket.itg.ti.com/projects/MODELS/repos/example_pspice_and_tina/browse
    
"Development-NameOfSimulator" folder should be renamed to reflect the simulator name. For example: 
- Development-Pspice
- Development-TINA
- Development-IBIS
- Development-SIMPLIS

Follow these steps to rename "Development-NameOfSimulator" folder: https://confluence.itg.ti.com/x/uwP0DQ