* OPA364 SPICE Macro-model 
*          
*   Rev. A    12 December 2003, by W.K. Sands
*
*   Rev. B    16 December 2003 By Neil Albaugh: ADDED HEADER TEXT & EDITED TEXT
*
*	This macromodel has been optimized to model the AC, DC, and transient response performance within 
*     the device data sheet specified limits. 
*     Correct operation of this macromodel has been verified on MicroSim P-Spice ver. 8.0 and on 
*     PENZAR Development TopSPICE ver. 6.82d. For help with other analog simulation software, 
*     please consult your software supplier. 
*
*  
*   Copyright 2003 by Texas Instruments Corporation
*
* BEGIN MODEL OPA364
*
* BEGIN NOTES
*
*
* MODEL TEMPERATURE RANGE IS -40 C TO +125 C, NOT ALL PARAMETERS ACCURATELY TRACK THOSE OF AN ACTUAL OPA364 
* OVER THE FULL TEMPERATURE RANGE BUT ARE AS CLOSE AS PRACTICAL
*
* END NOTES
*
* BEGIN MODELED FEATURES
*
* OPEN LOOP GAIN AND PHASE
* INPUT VOLTAGE NOISE
* INPUT CURRENT NOISE
* INPUT BIAS CURRENT
* SAME VERSUS TEMPERATURE
* INPUT CAPACITANCE
* INPUT COMMON MODE VOLTAGE RANGE
* INPUT CLAMPS TO RAILS
* CMRR WITH FREQUENCY EFFECTS
* PSRR WITH FREQUENCY EFFECTS
* SLEW RATE
* QUIESCENT CURRENT
* QUIESCENT CURRENT VS VOLTAGE
* RAIL TO RAIL OUTPUT STAGE
* HIGH CLOAD EFFECTS
* CLASS AB BIAS IN OUTPUT STAGE
* OUTPUT CURRENT THROUGH SUPPLIES
* OUTPUT CURRENT LIMITING
* OUTPUT CLAMPS TO RAILS
* OUTPUT SWING VS OUTPUT CURRENT
* OUTPUT SWING VS SUPPLY VOLT
* OUTPUT WILL SWING SLIGHTLY BELOW -V W EXTERNAL PULLDOWN TO A SUPPLY MORE NEGATIVE THAN -V
*
* END FEATURES
*
*
* PINOUT ORDER +IN -IN +V -V OUT
* PINOUT ORDER  3   4   6  2  1
*
.SUBCKT OPA364 3 4 6 2 1
*
VEN 5 2 1
RVEN 5 2 1E9
Q20 7 8 9 QLN
R3 10 11 20
R4 12 11 20
R10 8 13 1E3
R11 14 15 1E3
R12 15 6 7
R13 2 13 7
R16 16 17 300
R17 18 19 7
R18 9 20 7
D5 1 6 DD
D6 2 1 DD
D7 21 0 DIN
D8 22 0 DIN
I8 0 21 0.1E-3
I9 0 22 0.1E-3
E2 9 0 2 0 1
E3 19 0 6 0 1
D9 23 0 DVN
D10 24 0 DVN
I10 0 23 0.1E-3
I11 0 24 0.1E-3
E4 25 4 23 24 0.07
G2 26 4 21 22 2.8E-7
R22 2 6 100E6
E5 27 0 28 0 1
E6 29 0 9 0 1
E7 30 0 31 0 1
R30 27 32 1E5
R31 29 33 1E5
R32 30 34 1E5
R33 0 32 10
R34 0 33 10
R35 0 34 10
E10 35 3 34 0 0.11
R36 36 31 1K
R37 31 37 1K
C6 27 32 2E-12
C7 29 33 2E-12
C8 30 34 2E-12
E11 38 35 33 0 1
E12 26 38 32 0 1
E14 39 9 19 9 0.5
D11 16 19 DD
D12 9 16 DD
M1 40 41 13 13 NOUT L=3U W=400U
M2 42 43 15 15 POUT L=3U W=1400U
M3 44 44 18 18 POUT L=3U W=1400U
M4 45 46 10 10 PIN L=3U W=160U
M5 47 48 12 12 PIN L=3U W=160U
M8 49 49 20 20 NOUT L=3U W=400U
R43 50 43 100
R44 51 41 100
G3 16 39 52 39 0.2E-3
R45 39 16 2.5E6
C12 17 1 10E-12
R46 9 45 2E3
R47 9 47 2E3
C13 45 47 1E-12
C14 26 0 3E-12
C15 25 0 3E-12
C16 1 0 0.5E-12
D13 41 7 DD
D14 53 43 DD
Q15 53 14 19 QLP
V18 26 54 0.18M
M19 55 56 28 28 PIN L=6U W=500U
E17 37 0 26 0 1
E18 36 0 4 0 1
M23 56 56 28 28 PIN L=6U W=500U
V21 55 11 0.9
R59 1 42 17
R60 40 1 53
J1 57 26 57 JNC
J2 57 25 57 JNC
J3 25 58 25 JNC
J4 26 58 26 JNC
C21 26 59 2E-12
E20 60 39 47 45 1
R62 60 52 1E4
C23 52 39 0.1E-12
G7 61 39 16 39 -1E-3
G8 39 62 16 39 1E-3
G9 39 63 49 9 1E-3
G10 64 39 19 44 1E-3
D17 64 61 DD
D18 62 63 DD
R66 61 64 100E6
R67 63 62 100E6
R68 64 19 1E3
R69 9 63 1E3
E23 19 50 19 64 1
E24 51 9 63 9 1
R70 62 39 1E6
R71 63 39 1E6
R72 39 64 1E6
R73 39 61 1E6
G11 6 2 65 0 0.2E-3
R75 38 26 1E9
R76 35 38 1E9
R77 3 35 1E9
R78 4 25 1E9
R79 39 52 1E9
R81 50 19 1E9
R82 9 51 1E9
R83 31 0 1E9
G14 56 9 65 0 125E-6
G15 44 49 65 0 225E-6
E48 66 16 65 0 30
E49 67 39 65 0 -30
V49 68 67 15
V50 69 66 -15
R127 66 0 1E12
R128 67 0 1E12
M41 39 69 16 70 PSW L=1.5U W=150U
M42 16 68 39 71 NSW L=1.5U
R129 70 0 1E12
R130 71 0 1E12
M43 72 5 9 9 NEN L=3U W=300U
M44 73 74 9 9 NEN L=3U W=3000U
R131 72 28 1E4
R132 73 75 1E6
V51 75 9 1
I20 5 9 10E-12
C26 5 0 1E-12
E50 65 0 76 9 1
V52 73 76 1.111E-6
R133 9 76 1E12
C32 28 72 15E-12
I21 6 2 0.9E-6
V78 28 57 0
V79 58 9 0.05
R155 44 19 1E8
R156 9 49 1E8
R157 13 41 1E8
R158 15 43 1E8
RG1 0 65 1E9
R159 59 25 100
V82 28 19 1.8
R225 48 25 5200
R226 46 54 5200
G34 25 0 77 0 10E-12
I40 25 0 1E-12
I45 0 78 1M
D43 78 0 DD
V111 78 79 0.7
R293 0 79 1E6
E92 80 0 79 0 -571
R294 0 80 1E6
R295 81 80 1E6
D44 82 81 DD
V112 82 83 27
V113 81 77 26.4
I46 0 84 1M
D45 84 0 DD
V114 84 85 0.7
R296 0 85 1E6
E93 83 0 85 0 1
G35 26 0 77 0 10E-12
I47 26 0 1E-12
M48 86 87 2 2 NIQ L=3U W=1000U
R297 86 6 8E3
E94 87 2 65 0 2
M49 88 72 9 9 NEN L=3U W=300U
M50 74 88 9 9 NEN L=3U W=300U
R298 88 75 1E4
R299 74 75 1E4
C35 75 88 2.3E-9
R300 0 77 1E9
R301 0 77 1E9
.MODEL DVN D KF=8E-12 IS=1E-16
.MODEL DD D
.MODEL DIN D
.MODEL QLN NPN
.MODEL QLP PNP
.MODEL JNC NJF
.MODEL POUT PMOS KP=200U VTO=-0.7
.MODEL NOUT NMOS KP=200U VTO=0.7
.MODEL PIN PMOS KP=200U VTO=-0.7
.MODEL NIN NMOS KP=200U VTO=0.7
.MODEL NIQ NMOS KP=200U VTO=0.7 IS=1E-18
.MODEL NEN NMOS KP=200U VTO=0.5 IS=1E-18
.MODEL PEN PMOS KP=200U VTO=-0.7 IS=1E-18
.MODEL PSW PMOS KP=200U VTO=-7.5 IS=1E-18
.MODEL NSW NMOS KP=200U VTO=7.5 IS=1E-18
.ENDS
* END MODEL OPA364
